%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    MoM program for a rectangular charged plate


clear all; 
close all;

a = 1;
b = 2;
V0 = 1;
EPS0 = 8.8542*10^(-12);
n = 10;
m = 20;
N = n*m;  %total number of patches

%coordinates of centers of patches

[x,y,S] = localCoordinates(n,m,a,b);

%matrix A 

A = matrixA(EPS0,S,x,y);

%matrix B

B = V0*ones(1,N)';  %transpose -- to make it a column matrix

rhos = A\B;  %solving the equation

% making 2D matrix rhos2D from results rhos in 1D array

for i = 1:n
rhos2D(i,:) = rhos((i-1)*m +1:i*m);
end;

figure(1);

surf(rhos2D);
colormap('cool');
shading interp;
title(' Surface charge distribution of the plate');
xlabel('x [m]');
ylabel('y [m]');
zlabel('\rho_s [^{pC}/_{m^2}]');


figure(2);

imagesc(rhos2D);
colormap('cool');
axis equal;
shading interp;
title('Surface charge density in C/m^2');
xlabel('x');
ylabel('y');

Qtot = totalCharge(S,rhos);

fprintf('\nTotal charge of rectangular plate is %2.3d pC', Qtot*10^12);